﻿//////////////////////////////////////////////
// TestObserver.h
// 
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Forward decl -----------------------------

namespace nkDebug
{
	class TestClassObserverInformation ;
	class TestFunctionObserverInformation ;
	class TestRunParameters ;
}

/// Includes ---------------------------------

// nkDebug
#include "../../Dll/DllDefines.h"

/// Class ------------------------------------

namespace nkDebug
{
	class DLL_NKDEBUG_EXPORT TestObserver
	{
		public  :

			// Functions
			// Constructor, destructor
			TestObserver () noexcept ;
			virtual ~TestObserver () ;

			// Hooks
			virtual void onRunLaunch (const TestRunParameters& params) ;
			virtual void onRunEnd () ;
			virtual void onClassLaunch (const TestClassObserverInformation& info) ;
			virtual void onClassBypass (const TestClassObserverInformation& info) ;
			virtual void onClassEnd (const TestClassObserverInformation& info) ;
			virtual void onTestLaunch (const TestFunctionObserverInformation& info) ;
			virtual void onTestBypass (const TestFunctionObserverInformation& info) ;
			virtual void onTestSuccess (const TestFunctionObserverInformation& info) ;
			virtual void onTestFailure (const TestFunctionObserverInformation& info) ;
	} ;
}